<?php
ini_set('display_errors','1'); ini_set('display_startup_errors','1'); error_reporting(E_ALL);
require_once __DIR__ . '/../app/core/auth.php';
require_login();

require_once __DIR__ . '/../app/config/db.php';
require_once __DIR__ . '/../app/core/helpers.php';
require_once __DIR__ . '/../app/core/rbac.php';

/* Somente admin (global ou por empresa) */
require_role('admin');

/* Escopo (admin global pode não ter empresa_id) */
$scope     = current_scope();
$empresaId = $scope['empresa_id'] ? (int)$scope['empresa_id'] : null;

/* Contadores */
if ($empresaId) {
  $empresas  = (int)$pdo->query("SELECT COUNT(*) FROM empresas WHERE id={$empresaId}")->fetchColumn();
  $gerencias = (int)$pdo->query("SELECT COUNT(*) FROM gerencias WHERE empresa_id={$empresaId}")->fetchColumn();
  $setores   = (int)$pdo->query("SELECT COUNT(*) FROM setores WHERE empresa_id={$empresaId}")->fetchColumn();
  $colabs    = (int)$pdo->query("SELECT COUNT(*) FROM colaboradores WHERE empresa_id={$empresaId}")->fetchColumn();
  $modelos   = (int)$pdo->query("SELECT COUNT(*) FROM checklists WHERE empresa_id={$empresaId}")->fetchColumn();
  $execucoes = (int)$pdo->query("
    SELECT COUNT(*) FROM execucoes ex
    JOIN checklists c ON c.id = ex.checklist_id
    WHERE c.empresa_id = {$empresaId}
  ")->fetchColumn();
} else {
  $empresas  = (int)$pdo->query("SELECT COUNT(*) FROM empresas")->fetchColumn();
  $gerencias = (int)$pdo->query("SELECT COUNT(*) FROM gerencias")->fetchColumn();
  $setores   = (int)$pdo->query("SELECT COUNT(*) FROM setores")->fetchColumn();
  $colabs    = (int)$pdo->query("SELECT COUNT(*) FROM colaboradores")->fetchColumn();
  $modelos   = (int)$pdo->query("SELECT COUNT(*) FROM checklists")->fetchColumn();
  $execucoes = (int)$pdo->query("SELECT COUNT(*) FROM execucoes")->fetchColumn();
}

$pageTitle = 'Dashboard';
include __DIR__ . '/../app/partials/head.php';
include __DIR__ . '/../app/partials/topbar.php';
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Painel <?= $empresaId ? '' : '(Administrativo)' ?></h1>
  <div class="d-flex gap-2">
    <!--<a class="btn btn-outline-secondary" href="<?= e(url('relatorios/index.php')) ?>">Relatórios</a>-->
  </div>
</div>

<div class="row g-3">
  <div class="col-sm-6 col-lg-3">
    <div class="card h-100">
      <div class="card-body">
        <div class="fw-bold">Empresas</div>
        <div class="display-6"><?= (int)$empresas ?></div>
        <a class="btn btn-sm btn-outline-primary mt-2" href="<?= e(url('empresas/index.php')) ?>">Gerenciar</a>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card h-100">
      <div class="card-body">
        <div class="fw-bold">Gerências</div>
        <div class="display-6"><?= (int)$gerencias ?></div>
        <a class="btn btn-sm btn-outline-primary mt-2" href="<?= e(url('gerencias/index.php')) ?>">Gerenciar</a>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card h-100">
      <div class="card-body">
        <div class="fw-bold">Setores</div>
        <div class="display-6"><?= (int)$setores ?></div>
        <a class="btn btn-sm btn-outline-primary mt-2" href="<?= e(url('setores/index.php')) ?>">Gerenciar</a>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card h-100">
      <div class="card-body">
        <div class="fw-bold">Colaboradores</div>
        <div class="display-6"><?= (int)$colabs ?></div>
        <a class="btn btn-sm btn-outline-primary mt-2" href="<?= e(url('colaboradores/index.php')) ?>">Gerenciar</a>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card h-100">
      <div class="card-body">
        <div class="fw-bold">Checklists (modelos)</div>
        <div class="display-6"><?= (int)$modelos ?></div>
        <a class="btn btn-sm btn-outline-primary mt-2" href="<?= e(url('checklists/index.php')) ?>">Ver modelos</a>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card h-100">
      <div class="card-body">
        <div class="fw-bold">Execuções</div>
        <div class="display-6"><?= (int)$execucoes ?></div>
        <a class="btn btn-sm btn-outline-primary mt-2" href="<?= e(url('execucoes/index.php')) ?>">Histórico</a>
      </div>
    </div>
  </div>

  <div class="col-lg-6">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Atalhos</h5>
        <div class="d-flex flex-wrap gap-2">
          
          <a class="btn btn-outline-primary" href="<?= e(url('empresas/novo.php')) ?>">+ empresa</a>
          <a class="btn btn-outline-primary" href="<?= e(url('gerencias/novo.php')) ?>">+ gerência</a>
          <a class="btn btn-outline-primary" href="<?= e(url('setores/novo.php')) ?>">+ setor</a>
          <a class="btn btn-outline-primary" href="<?= e(url('colaboradores/novo.php')) ?>">+ colaborador</a>
          
        </div>
        <div class="text-muted mt-2">
          <a class="btn btn-primary" href="<?= e(url('checklists/novo.php')) ?>">+ checklist</a>
          <a class="btn btn-outline-dark" href="<?= e(url('comparador/index.php')) ?>">Comparador</a>
          <a class="btn btn-outline-dark" href="<?= e(url('relatorios/index.php')) ?>">Relatorios</a>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../app/partials/foot.php'; ?>
