<?php
// public/checklists/index.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

// 🔒 só admin
require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin'); // se não for admin, redireciona/negar conforme sua rbac

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Checklists (Modelos)';
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

$q         = trim($_GET['q'] ?? '');
$empresaId = (int)($_GET['empresa_id'] ?? 0);
$status    = $_GET['status'] ?? '';
$page      = max(1, (int)($_GET['p'] ?? 1)); $pp=10; $off=($page-1)*$pp;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (isset($_POST['ativar_id'])) {
    $st=$pdo->prepare("UPDATE checklists SET status='ativo' WHERE id=?");
    $st->execute([(int)$_POST['ativar_id']]);
  }
  if (isset($_POST['inativar_id'])) {
    $st=$pdo->prepare("UPDATE checklists SET status='inativo' WHERE id=?");
    $st->execute([(int)$_POST['inativar_id']]);
  }
  header("Location: ".url('checklists/index.php')); exit;
}

$empresas = $pdo->query("SELECT id, razao_social FROM empresas WHERE status='ativo' ORDER BY razao_social")->fetchAll();

$params=[]; $where="WHERE 1=1";
if ($q!==''){ $where.=" AND (c.titulo LIKE :q OR c.descricao LIKE :q)"; $params[':q']="%$q%"; }
if ($empresaId>0){ $where.=" AND c.empresa_id=:e"; $params[':e']=$empresaId; }
if ($status==='rascunho' || $status==='ativo' || $status==='inativo'){ $where.=" AND c.status=:s"; $params[':s']=$status; }

$sqlCount=$pdo->prepare("SELECT COUNT(*) c FROM checklists c $where"); $sqlCount->execute($params);
$rows=(int)$sqlCount->fetch()['c'];

$sql=$pdo->prepare("
  SELECT c.*, e.razao_social
  FROM checklists c
  JOIN empresas e ON e.id=c.empresa_id
  $where
  ORDER BY c.criado_em DESC, c.id DESC
  LIMIT $pp OFFSET $off
"); $sql->execute($params); $data=$sql->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Checklists (Modelos)</h1>
  <a href="<?= e(url('checklists/novo.php')) ?>" class="btn btn-primary">Novo checklist</a>
</div>

<form class="row g-2 mb-3">
  <div class="col-12 col-md-3"><input name="q" class="form-control" placeholder="Buscar título/descrição" value="<?= e($q) ?>"></div>
  <div class="col-12 col-md-4">
    <select name="empresa_id" class="form-select">
      <option value="0">Todas as empresas</option>
      <?php foreach($empresas as $e): ?>
        <option value="<?= (int)$e['id'] ?>" <?= $empresaId==$e['id']?'selected':'' ?>><?= e($e['razao_social']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="status" class="form-select">
      <option value="">Status (todos)</option>
      <option value="rascunho" <?= $status==='rascunho'?'selected':'' ?>>Rascunho</option>
      <option value="ativo" <?= $status==='ativo'?'selected':'' ?>>Ativo</option>
      <option value="inativo" <?= $status==='inativo'?'selected':'' ?>>Inativo</option>
    </select>
  </div>
  <div class="col-6 col-md-3">
    <button class="btn btn-outline-secondary">Filtrar</button>
    <a class="btn btn-link" href="<?= e(url('checklists/index.php')) ?>">Limpar</a>
  </div>
</form>

<div class="table-responsive">
<table class="table table-striped align-middle">
  <thead><tr>
    <th>ID</th><th>Empresa</th><th>Título</th><th>Criado em</th><th></th>
  </tr></thead>
  <tbody>
  <?php foreach($data as $r): ?>
    <tr>
      <td><?= (int)$r['id'] ?></td>
      <td><?= e($r['razao_social']) ?></td>
      <td><?= e($r['titulo']) ?></td>
      <td><?= e($r['criado_em']) ?></td>
      <td class="text-end">
        <a class="btn btn-sm btn-outline-primary" href="<?= e(url('checklists/editar.php?id='.$r['id'])) ?>">Ações</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>

<?php $pages=(int)ceil($rows/$pp); if($pages>1): ?>
<nav><ul class="pagination">
  <?php for($i=1;$i<=$pages;$i++): ?>
  <li class="page-item <?= $i==$page?'active':'' ?>">
    <a class="page-link" href="?p=<?= $i ?>&q=<?= urlencode($q) ?>&empresa_id=<?= $empresaId ?>&status=<?= urlencode($status) ?>"><?= $i ?></a>
  </li>
  <?php endfor; ?>
</ul></nav>
<?php endif; ?>
<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
