<?php
if (!isset($_SESSION)) session_start();
require_once __DIR__ . '/helpers.php';

/** Hidrata $_SESSION['user']['role'] e escopo a partir do banco, se estiver vazio */
function hydrate_role_from_db(): void {
  if (!isset($_SESSION['user']['id'])) return;
  if (!empty($_SESSION['user']['role']) && isset($_SESSION['user']['empresa_id'])) return;

  require_once __DIR__ . '/../config/db.php';
  global $pdo; // <<< NECESSÁRIO
  $st = $pdo->prepare("
    SELECT r.nome AS role_nome, u.empresa_id, u.gerencia_id, u.colaborador_id
    FROM usuarios u
    LEFT JOIN roles r ON r.id = u.role_id
    WHERE u.id = ?
    LIMIT 1
  ");
  $st->execute([ (int)$_SESSION['user']['id'] ]);
  if ($row = $st->fetch()) {
    $_SESSION['user']['role']           = $row['role_nome'] ?: null;          // 'admin' | 'gerente' | 'diretor' | 'empresa_user'
    $_SESSION['user']['empresa_id']     = $row['empresa_id'] ?: null;
    $_SESSION['user']['gerencia_id']    = $row['gerencia_id'] ?: null;
    $_SESSION['user']['colaborador_id'] = $row['colaborador_id'] ?: null;
  }
}

/** Role atual (normalizado) */
function current_role(): ?string {
  if (empty($_SESSION['user']['role'])) {
    hydrate_role_from_db(); // tenta corrigir automaticamente
  }
  return $_SESSION['user']['role'] ?? null;
}

/** Escopo útil da sessão */
function current_scope(): array {
  if (!isset($_SESSION['user']['empresa_id'])) {
    hydrate_role_from_db();
  }
  return [
    'id'             => $_SESSION['user']['id']             ?? null,
    'empresa_id'     => $_SESSION['user']['empresa_id']     ?? null,
    'gerencia_id'    => $_SESSION['user']['gerencia_id']    ?? null,
    'colaborador_id' => $_SESSION['user']['colaborador_id'] ?? null,
  ];
}

/** Capacidades por perfil */
function role_caps(): array {
  return [
    'admin'        => ['crud_gerencias','crud_setores','crud_colaboradores','crud_checklists','ver_relatorios_empresa'],
    'gerente'      => ['ver_relatorios_consolidados'],
    'diretor'      => ['ver_relatorios_consolidados'],
    'empresa_user' => ['executar_checklist'],
  ];
}

/** Checagem de capacidade */
function can(string $cap): bool {
  $role = current_role();
  if (!$role) return false;
  $caps = role_caps()[$role] ?? [];
  return in_array($cap, $caps, true);
}

/** Exige capacidade */
function require_capability($caps): void {
  if (!isset($_SESSION['user'])) redirect('login.php');
  foreach ((array)$caps as $cap) {
    if (can($cap)) return;
  }
  http_response_code(403);
  echo "<div class='container mt-4'><div class='alert alert-danger'>Acesso negado.</div></div>";
  exit;
}

/** Exige role */
function require_role($roles): void {
  if (!isset($_SESSION['user'])) redirect('login.php');
  $r = current_role();
  if (!in_array($r, (array)$roles, true)) {
    http_response_code(403);
    echo "<div class='container mt-4'><div class='alert alert-danger'>Acesso negado.</div></div>";
    exit;
  }
}
