<?php
// public/gerencias/index.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

// 🔒 apenas admin
require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin');

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Gerências';

$q         = trim($_GET['q'] ?? '');
$empresaId = (int)($_GET['empresa_id'] ?? 0);
$status    = $_GET['status'] ?? '';
$page      = max(1, (int)($_GET['p'] ?? 1));
$pp        = 10;
$off       = ($page - 1) * $pp;

/* Ações POST (somente admin já garantido no topo) */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['inativar_id'])) {
  $gid = (int)$_POST['inativar_id'];
  $st  = $pdo->prepare("UPDATE gerencias SET status='inativo' WHERE id=?");
  $st->execute([$gid]);
  header("Location: " . url('gerencias/index.php'));
  exit;
}

/* Filtros auxiliares */
$empresas = $pdo->query("
  SELECT id, razao_social
    FROM empresas
   WHERE status='ativo'
   ORDER BY razao_social
")->fetchAll();

$params = [];
$where  = "WHERE 1=1";

if ($q !== '') {
  $where .= " AND g.nome LIKE :q";
  $params[':q'] = "%{$q}%";
}
if ($empresaId > 0) {
  $where .= " AND g.empresa_id = :e";
  $params[':e'] = $empresaId;
}
if ($status === 'ativo' || $status === 'inativo') {
  $where .= " AND g.status = :s";
  $params[':s'] = $status;
}

/* Contagem e listagem */
$sqlCount = $pdo->prepare("SELECT COUNT(*) c FROM gerencias g $where");
$sqlCount->execute($params);
$rows = (int)$sqlCount->fetch()['c'];

$sql = $pdo->prepare("
  SELECT g.*, e.razao_social
    FROM gerencias g
    JOIN empresas e ON e.id = g.empresa_id
    $where
   ORDER BY g.criado_em DESC, g.id DESC
   LIMIT $pp OFFSET $off
");
$sql->execute($params);
$data = $sql->fetchAll();

/* View */
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Gerências</h1>
  <a href="<?= e(url('gerencias/novo.php')) ?>" class="btn btn-primary">Nova gerência</a>
</div>

<form class="row g-2 mb-3">
  <div class="col-12 col-md-3">
    <input type="text" name="q" class="form-control" placeholder="Buscar por nome" value="<?= e($q) ?>">
  </div>
  <div class="col-12 col-md-4">
    <select name="empresa_id" class="form-select">
      <option value="0">Todas as empresas</option>
      <?php foreach ($empresas as $e): ?>
        <option value="<?= (int)$e['id'] ?>" <?= $empresaId == $e['id'] ? 'selected' : '' ?>>
          <?= e($e['razao_social']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="status" class="form-select">
      <option value="">Status (todos)</option>
      <option value="ativo"   <?= $status === 'ativo' ? 'selected' : '' ?>>Ativo</option>
      <option value="inativo" <?= $status === 'inativo' ? 'selected' : '' ?>>Inativo</option>
    </select>
  </div>
  <div class="col-6 col-md-3">
    <button class="btn btn-outline-secondary">Filtrar</button>
    <a class="btn btn-link" href="<?= e(url('gerencias/index.php')) ?>">Limpar</a>
  </div>
</form>

<div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead>
      <tr>
        <th>ID</th>
        <th>Empresa</th>
        <th>Nome</th>
        <th>Responsável</th>
        <th>Status</th>
        <th></th>
      </tr>
    </thead>
    <tbody>
      <?php if (!$data): ?>
        <tr><td colspan="6" class="text-muted">Nenhuma gerência encontrada.</td></tr>
      <?php else: ?>
        <?php foreach ($data as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= e($r['razao_social']) ?></td>
            <td><?= e($r['nome']) ?></td>
            <td><?= e($r['responsavel']) ?></td>
            <td>
              <span class="badge bg-<?= $r['status'] === 'ativo' ? 'success' : 'secondary' ?>">
                <?= e($r['status']) ?>
              </span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="<?= e(url('gerencias/editar.php?id=' . $r['id'])) ?>">Editar</a>
              <?php if ($r['status'] === 'ativo'): ?>
                <form method="post" class="d-inline" onsubmit="return confirm('Inativar esta gerência?');">
                  <input type="hidden" name="inativar_id" value="<?= (int)$r['id'] ?>">
                  <button class="btn btn-sm btn-outline-danger">Inativar</button>
                </form>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<?php
$pages = (int)ceil($rows / $pp);
if ($pages > 1): ?>
  <nav>
    <ul class="pagination">
      <?php for ($i = 1; $i <= $pages; $i++): ?>
        <li class="page-item <?= $i == $page ? 'active' : '' ?>">
          <a class="page-link"
             href="?p=<?= $i ?>&q=<?= urlencode($q) ?>&empresa_id=<?= $empresaId ?>&status=<?= urlencode($status) ?>">
            <?= $i ?>
          </a>
        </li>
      <?php endfor; ?>
    </ul>
  </nav>
<?php endif; ?>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
