<?php
// public/execucoes/finalizar.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('empresa_user');

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$u = current_user();
$empresaId = (int)($u['empresa_id'] ?? 0);
$execId = (int)($_GET['id'] ?? 0);

if ($execId <= 0 || $empresaId <= 0) redirect('empresa_user/index.php');

$st = $pdo->prepare("SELECT id, status FROM execucoes WHERE id=? AND empresa_id=? LIMIT 1");
$st->execute([$execId, $empresaId]);
$exec = $st->fetch(PDO::FETCH_ASSOC);
if (!$exec) redirect('empresa_user/index.php');

if ($exec['status'] !== 'finalizado') {
  $up = $pdo->prepare("UPDATE execucoes SET status='finalizado', finalizado_em=NOW() WHERE id=?");
  $up->execute([$execId]);
}

// após finalizar, manda para o detalhe
redirect('execucoes/detalhe.php?id='.$execId);
