<?php
// public/checklists/novo.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin'); // 🔒 apenas admin cria modelos

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Novo Checklist (Modelo)';

/* Carregar empresas ativas */
$empresas = $pdo->query("
  SELECT id, razao_social
    FROM empresas
   WHERE status = 'ativo'
   ORDER BY razao_social
")->fetchAll();

/* Estado do form */
$errors = [];
$old = [
  'empresa_id' => $_POST['empresa_id'] ?? '',
  'titulo'     => $_POST['titulo'] ?? '',
  'descricao'  => $_POST['descricao'] ?? '',
];

/* POST */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $empresa_id = (int)($_POST['empresa_id'] ?? 0);
  $titulo     = trim($_POST['titulo'] ?? '');
  $descricao  = trim($_POST['descricao'] ?? '');

  // validações
  if ($empresa_id <= 0) {
    $errors[] = 'Selecione a empresa.';
  } else {
    $chk = $pdo->prepare("SELECT COUNT(*) FROM empresas WHERE id=? AND status='ativo'");
    $chk->execute([$empresa_id]);
    if (!(int)$chk->fetchColumn()) {
      $errors[] = 'Empresa inválida ou inativa.';
    }
  }

  if ($titulo === '') {
    $errors[] = 'Título é obrigatório.';
  }

  if (!$errors) {
    $ins = $pdo->prepare("
      INSERT INTO checklists (empresa_id, titulo, descricao, status, criado_em)
      VALUES (?, ?, ?, 'rascunho', NOW())
    ");
    if ($ins->execute([$empresa_id, $titulo, $descricao])) {
      $id = (int)$pdo->lastInsertId();
      // vai direto para a montagem/edição (tab dados)
      redirect('checklists/editar.php?id='.$id.'&tab=dados');
    } else {
      $errors[] = 'Não foi possível criar o checklist.';
    }
  }
}

include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>

<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0">Novo checklist (modelo)</h1>
    <a href="<?= e(url('checklists/index.php')) ?>" class="btn btn-outline-secondary">Voltar</a>
  </div>

  <?php if ($errors): ?>
    <div class="alert alert-danger">
      <strong>Não foi possível salvar:</strong><br>
      <?= implode('<br>', array_map('e', $errors)) ?>
    </div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-12 col-md-6">
          <label class="form-label">Empresa</label>
          <select name="empresa_id" class="form-select" required>
            <option value="">Selecione</option>
            <?php foreach ($empresas as $e): ?>
              <option value="<?= (int)$e['id'] ?>" <?= ((string)$old['empresa_id'] === (string)$e['id']) ? 'selected' : '' ?>>
                <?= e($e['razao_social']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Título</label>
          <input name="titulo" class="form-control" required value="<?= e($old['titulo']) ?>">
        </div>

        <div class="col-12">
          <label class="form-label">Objetivo</label>
          <textarea name="descricao" class="form-control" rows="3"><?= e($old['descricao']) ?></textarea>
        </div>

        <div class="col-12">
          <button class="btn btn-primary">Criar e continuar</button>
          <a href="<?= e(url('checklists/index.php')) ?>" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
